<?php

/**
 * ajax -> admin -> reset
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch bootstrap
require('../../../bootstrap.php');

// check AJAX Request
is_ajax();

// check admin|moderator permission
if (!$user->_is_admin) {
  modal("MESSAGE", __("System Message"), __("You don't have the right permission to access this"));
}

// check demo account
if ($user->_data['user_demo']) {
  modal("ERROR", __("Demo Restriction"), __("You can't do this with demo account"));
}

try {

  // verify password
  $user->verify_password($_POST['password_check']);

  switch ($_POST['do']) {
    case 'factory_reset':
      // factory reset
      /* empty tables */
      $tables = [
        "ads_campaigns",
        "ads_system",
        "affiliates_payments",
        "announcements",
        "announcements_users",
        "auto_connect",
        "bank_transfers",
        "blacklist",
        "coinpayments_transactions",
        "conversations",
        "conversations_calls_audio",
        "conversations_calls_video",
        "conversations_messages",
        "conversations_users",
        "custom_fields",
        "custom_fields_values",
        "developers_apps",
        "developers_apps_users",
        "events",
        "events_members",
        "followings",
        "forums",
        "forums_replies",
        "forums_threads",
        "friends",
        "funding_payments",
        "games",
        "games_players",
        "gifts",
        "groups",
        "groups_admins",
        "groups_invites",
        "groups_members",
        "hashtags",
        "hashtags_posts",
        "invitation_codes",
        "log_commissions",
        "log_payments",
        "log_points",
        "log_sessions",
        "log_subscriptions",
        "market_payments",
        "merits_categories",
        "monetization_payments",
        "monetization_plans",
        "movies",
        "movies_payments",
        "notifications",
        "orders",
        "orders_items",
        "packages",
        "packages_payments",
        "pages",
        "pages_admins",
        "pages_invites",
        "pages_likes",
        "points_payments",
        "posts",
        "posts_articles",
        "posts_audios",
        "posts_cache",
        "posts_comments",
        "posts_comments_reactions",
        "posts_courses",
        "posts_courses_applications",
        "posts_files",
        "posts_funding",
        "posts_funding_donors",
        "posts_hidden",
        "posts_jobs",
        "posts_jobs_applications",
        "posts_links",
        "posts_live",
        "posts_live_users",
        "posts_media",
        "posts_merits",
        "posts_offers",
        "posts_paid",
        "posts_photos",
        "posts_photos_albums",
        "posts_photos_reactions",
        "posts_polls",
        "posts_polls_options",
        "posts_polls_options_users",
        "posts_products",
        "posts_reactions",
        "posts_reels",
        "posts_saved",
        "posts_videos",
        "posts_views",
        "reports",
        "reviews",
        "reviews_photos",
        "shopping_cart",
        "sneak_peaks",
        "stories",
        "stories_media",
        "subscribers",
        "users_accounts",
        "users_addresses",
        "users_affiliates",
        "users_blocks",
        "users_gifts",
        "users_groups",
        "users_invitations",
        "users_merits",
        "users_pokes",
        "users_recurring_payments",
        "users_searches",
        "users_sms",
        "users_top_friends",
        "users_uploads",
        "verification_requests",
        "wallet_payments",
        "wallet_transactions",
        "widgets",
      ];
      foreach ($tables as $table) {
        $db->query(sprintf("TRUNCATE `%s`", $table));
      }
      /* delete all other users */
      $db->query(sprintf("DELETE FROM users WHERE user_id != %s", secure($user->_data['user_id'], "int")));
      /* delete all other users sessions */
      $db->query(sprintf("DELETE FROM users_sessions WHERE user_id != %s", secure($user->_data['user_id'], "int")));
      /* reset admin account details */
      $db->query(sprintf("UPDATE users SET 
          user_live_requests_counter = '0', 
          user_live_requests_lastid = '0', 
          user_live_messages_counter = '0', 
          user_live_messages_lastid = '0', 
          user_live_notifications_counter = '0', 
          user_live_notifications_lastid = '0', 
          user_picture = NULL, 
          user_picture_id = NULL, 
          user_cover = NULL, 
          user_cover_id = NULL, 
          user_cover_position = NULL, 
          user_album_pictures = NULL, 
          user_album_covers = NULL, 
          user_album_timeline = NULL, 
          user_pinned_post = NULL, 
          user_affiliate_balance = '0', 
          user_market_balance = '0', 
          user_funding_balance = '0', 
          user_monetization_balance = '0', 
          user_monetization_chat_price = '0', 
          user_monetization_call_price = '0', 
          user_monetization_min_price = '0', 
          user_monetization_plans = '0', 
          user_wallet_balance = '0', 
          user_points = '0' 
          WHERE user_id = %s", secure($user->_data['user_id'], "int")));
      /* delete all users groups */
      $db->query("DELETE FROM users_groups");
      $db->query("ALTER TABLE users_groups AUTO_INCREMENT = 1");
      /* delete all other permissions_groups */
      $db->query("DELETE FROM permissions_groups WHERE permissions_group_id > 2");
      $db->query("ALTER TABLE permissions_groups AUTO_INCREMENT = 3");
      /* reset system options settings */
      update_system_options([
        'system_email' => secure(''),
        'courses_enabled' => secure('0'),
        'forums_enabled' => secure('0'),
        'movies_enabled' => secure('0'),
        'games_enabled' => secure('0'),
        'location_finder_enabled' => secure('0'),
        'cookie_consent_enabled' => secure('1'),
        'gifts_enabled' => secure('0'),
        'adblock_detector_enabled' => secure('0'),
        'posts_approval_enabled' => secure('0'),
        'newsfeed_source' => secure('default'),
        'newsfeed_merge_enabled' => secure('1'),
        'merge_recent_results' => secure('12'),
        'merge_popular_results' => secure('3'),
        'merge_discover_results' => secure('3'),
        'newsfeed_caching_enabled' => secure('0'),
        'smooth_infinite_scroll' => secure('0'),
        'newsfeed_location_filter_enabled' => secure('1'),
        'popular_posts_interval' => secure('month'),
        'popular_posts_enabled' => secure('1'),
        'geolocation_enabled' => secure('0'),
        'geolocation_key' => secure(''),
        'gif_enabled' => secure('0'),
        'giphy_key' => secure(''),
        'post_translation_enabled' => secure('0'),
        'google_translation_key' => secure(''),
        'yandex_key' => secure(''),
        'smart_yt_player' => secure('1'),
        'disable_yt_player' => secure('1'),
        'registration_type' => secure('free'),
        'invitation_enabled' => secure('0'),
        'whitelist_enabled' => secure('0'),
        'whitelist_providers' => secure(''),
        'social_login_enabled' => secure('0'),
        'facebook_login_enabled' => secure('0'),
        'facebook_appid' => secure(''),
        'facebook_secret' => secure(''),
        'google_login_enabled' => secure('0'),
        'google_appid' => secure(''),
        'google_secret' => secure(''),
        'twitter_login_enabled' => secure('0'),
        'twitter_appid' => secure(''),
        'twitter_secret' => secure(''),
        'linkedin_login_enabled' => secure('0'),
        'linkedin_appid' => secure(''),
        'linkedin_secret' => secure(''),
        'vkontakte_login_enabled' => secure('0'),
        'vkontakte_appid' => secure(''),
        'vkontakte_secret' => secure(''),
        'wordpress_login_enabled' => secure('0'),
        'wordpress_appid' => secure(''),
        'wordpress_secret' => secure(''),
        'sngine_login_enabled' => secure('0'),
        'sngine_appid' => secure(''),
        'sngine_secret' => secure(''),
        'sngine_app_domain' => secure(''),
        'sngine_app_name' => secure(''),
        'sngine_app_icon' => secure(''),
        'genders_disabled' => secure('0'),
        'show_usernames_enabled' => secure('0'),
        'disable_username_changes' => secure('0'),
        'email_smtp_enabled' => secure('0'),
        'email_smtp_authentication' => secure(''),
        'email_smtp_ssl' => secure(''),
        'email_smtp_server' => secure(''),
        'email_smtp_port' => secure(''),
        'email_smtp_username' => secure(''),
        'email_smtp_password' => secure(''),
        'email_smtp_setfrom' => secure(''),
        'sms_limit' => '3',
        'twilio_sid' => secure(''),
        'twilio_token' => secure(''),
        'twilio_phone' => secure(''),
        'bulksms_username' => secure(''),
        'bulksms_password' => secure(''),
        'infobip_username' => secure(''),
        'infobip_password' => secure(''),
        'msg91_authkey' => secure(''),
        'system_phone' => secure(''),
        'profile_notification_enabled' => secure('0'),
        'email_notifications' => secure('0'),
        'email_post_likes' => secure('0'),
        'email_post_comments' => secure('0'),
        'email_post_shares' => secure('0'),
        'email_wall_posts' => secure('0'),
        'email_mentions' => secure('0'),
        'email_profile_visits' => secure('0'),
        'email_friend_requests' => secure('0'),
        'email_admin_verifications' => secure('0'),
        'email_admin_post_approval' => secure('0'),
        'email_admin_user_approval' => secure('0'),
        'onesignal_notification_enabled' => secure('0'),
        'onesignal_app_id' => secure(''),
        'onesignal_api_key' => secure(''),
        'onesignal_messenger_notification_enabled' => secure('0'),
        'onesignal_messenger_app_id' => secure(''),
        'onesignal_messenger_api_key' => secure(''),
        'onesignal_timeline_notification_enabled' => secure('0'),
        'onesignal_timeline_app_id' => secure(''),
        'onesignal_timeline_api_key' => secure(''),
        'chat_translation_enabled' => secure('0'),
        'audio_call_enabled' => secure('0'),
        'video_call_enabled' => secure('0'),
        'twilio_sid' => secure(''),
        'twilio_apisid' => secure(''),
        'twilio_apisecret' => secure(''),
        'livekit_api_key' => secure(''),
        'livekit_api_secret' => secure(''),
        'livekit_ws_url' => secure(''),
        'live_enabled' => secure('0'),
        'save_live_enabled' => secure('0'),
        'agora_app_id' => secure(''),
        'agora_app_certificate' => secure(''),
        'agora_customer_id' => secure(''),
        'agora_customer_certificate' => secure(''),
        'agora_s3_bucket' => secure(''),
        'agora_s3_region' => secure(''),
        'agora_s3_key' => secure(''),
        'agora_s3_secret' => secure(''),
        'chunk_upload_size' => secure('100'),
        'allow_heif_images' => secure('0'),
        'watermark_enabled' => secure('0'),
        'watermark_icon' => secure(''),
        'adult_images_enabled' => secure('0'),
        'adult_images_api_key' => secure(''),
        'ffmpeg_enabled' => secure('0'),
        'ffmpeg_path' => secure(''),
        'watermark_videos_enabled' => secure('0'),
        'watermark_videos_icon' => secure(''),
        's3_enabled' => secure('0'),
        'google_cloud_enabled' => secure('0'),
        'digitalocean_enabled' => secure('0'),
        'wasabi_enabled' => secure('0'),
        'backblaze_enabled' => secure('0'),
        'yandex_cloud_enabled' => secure('0'),
        'cloudflare_r2_enabled' => secure('0'),
        'cloudflare_r2_bucket' => secure(''),
        'cloudflare_r2_key' => secure(''),
        'cloudflare_r2_secret' => secure(''),
        'cloudflare_r2_endpoint' => secure(''),
        'ftp_enabled' => secure('0'),
        's3_bucket' => secure(''),
        's3_region' => secure(''),
        's3_key' => secure(''),
        's3_secret' => secure(''),
        'google_cloud_bucket' => secure(''),
        'google_cloud_file' => secure(''),
        'digitalocean_space_name' => secure(''),
        'digitalocean_space_region' => secure(''),
        'digitalocean_key' => secure(''),
        'digitalocean_secret' => secure(''),
        'wasabi_bucket' => secure(''),
        'wasabi_region' => secure(''),
        'wasabi_key' => secure(''),
        'wasabi_secret' => secure(''),
        'backblaze_bucket' => secure(''),
        'backblaze_region' => secure(''),
        'backblaze_key' => secure(''),
        'backblaze_secret' => secure(''),
        'yandex_cloud_bucket' => secure(''),
        'yandex_cloud_region' => secure(''),
        'yandex_cloud_key' => secure(''),
        'yandex_cloud_secret' => secure(''),
        'ftp_hostname' => secure(''),
        'ftp_username' => secure(''),
        'ftp_password' => secure(''),
        'ftp_port' => secure(''),
        'ftp_path' => secure(''),
        'ftp_endpoint' => secure(''),
        'payment_fees_enabled' =>  secure('1'),
        'payment_fees_percentage' =>  secure('1'),
        'payment_vat_enabled' =>  secure('0'),
        'payment_country_vat_enabled' =>  secure('0'),
        'payment_vat_percentage' =>  secure('20'),
        'paypal_enabled' =>  secure('0'),
        'paypal_payouts_enabled' =>  secure('0'),
        'paypal_mode' => secure(''),
        'paypal_id' => secure(''),
        'paypal_secret' => secure(''),
        'paypal_webhook' => secure(''),
        'creditcard_enabled' =>  secure('0'),
        'alipay_enabled' =>  secure('0'),
        'stripe_mode' => secure(''),
        'stripe_test_secret' => secure(''),
        'stripe_test_publishable' => secure(''),
        'stripe_live_secret' => secure(''),
        'stripe_live_publishable' => secure(''),
        'stripe_webhook' => secure(''),
        'paystack_enabled' =>  secure('0'),
        'paystack_secret' => secure(''),
        'coinpayments_enabled' =>  secure('0'),
        'coinpayments_merchant_id' => secure(''),
        'coinpayments_ipn_secret' => secure(''),
        '2checkout_enabled' =>  secure('0'),
        '2checkout_mode' => secure(''),
        '2checkout_merchant_code' => secure(''),
        '2checkout_publishable_key' => secure(''),
        '2checkout_private_key' => secure(''),
        'authorize_net_enabled' =>  secure('0'),
        'authorize_net_api_login_id' => secure(''),
        'authorize_net_transaction_key' => secure(''),
        'razorpay_enabled' =>  secure('0'),
        'razorpay_key_id' => secure(''),
        'razorpay_key_secret' => secure(''),
        'cashfree_enabled' =>  secure('0'),
        'cashfree_mode' => secure(''),
        'cashfree_client_id' => secure(''),
        'cashfree_client_secret' => secure(''),
        'coinbase_enabled' =>  secure('0'),
        'coinbase_api_key' => secure(''),
        'securionpay_enabled' =>  secure('0'),
        'securionpay_api_key' => secure(''),
        'securionpay_api_secret' => secure(''),
        'moneypoolscash_enabled' =>  secure('0'),
        'moneypoolscash_payouts_enabled' =>  secure('0'),
        'moneypoolscash_api_key' => secure(''),
        'moneypoolscash_merchant_email' => secure(''),
        'moneypoolscash_merchant_password' => secure(''),
        'myfatoorah_enabled' =>  secure('0'),
        'myfatoorah_mode' =>  secure(''),
        'myfatoorah_test_token' =>  secure(''),
        'myfatoorah_live_token' =>  secure(''),
        'myfatoorah_live_api_url' =>  secure(''),
        'epayco_enabled' =>  secure('0'),
        'epayco_mode' =>  secure(''),
        'epayco_public_key' =>  secure(''),
        'epayco_private_key' =>  secure(''),
        'flutterwave_enabled' =>  secure('0'),
        'flutterwave_mode' =>  secure(''),
        'flutterwave_public_key' =>  secure(''),
        'flutterwave_secret_key' =>  secure(''),
        'flutterwave_encryption_key' =>  secure(''),
        'verotel_enabled' =>  secure('0'),
        'verotel_shop_id' =>  secure(''),
        'verotel_signature_key' =>  secure(''),
        'mercadopago_enabled' =>  secure('0'),
        'mercadopago_public_key' =>  secure(''),
        'mercadopago_access_token' =>  secure(''),
        'bank_transfers_enabled' => secure('0'),
        'bank_name' => secure(''),
        'bank_account_number' => secure(''),
        'bank_account_name' => secure(''),
        'bank_account_routing' => secure(''),
        'bank_account_country' => secure(''),
        'unusual_login_enabled' => secure('0'),
        'brute_force_detection_enabled' => secure(secure('1')),
        'brute_force_bad_login_limit' => secure(secure('5')),
        'brute_force_lockout_time' => secure(secure('10')),
        'two_factor_enabled' => secure(secure('1')),
        'two_factor_type' => secure(secure('google')),
        'password_complexity_enabled' => secure('0'),
        'reCAPTCHA_enabled' => secure('0'),
        'reCAPTCHA_site_key' => secure(''),
        'reCAPTCHA_secret_key' => secure(''),
        'turnstile_enabled' => secure('0'),
        'turnstile_site_key' => secure(''),
        'turnstile_secret_key' => secure(''),
        'data_heartbeat' => secure('5'),
        'chat_heartbeat' => secure('10'),
        'offline_time' => secure('10'),
        'newsfeed_results' => secure('12'),
        'pages_results' => secure('12'),
        'groups_results' => secure('12'),
        'events_results' => secure('12'),
        'blogs_results' => secure('12'),
        'marketplace_results' => secure('12'),
        'funding_results' => secure('12'),
        'offers_results' => secure('12'),
        'jobs_results' => secure('12'),
        'courses_results' => secure('12'),
        'games_results' => secure('12'),
        'search_results' => secure('12'),
        'min_results' => secure('5'),
        'max_results' => secure('10'),
        'min_results_even' => secure('6'),
        'max_results_even' => secure('12'),
        'analytics_code' => secure(''),
        'system_back_swipe' => secure('1'),
        'landing_page_template' => secure('elengine'),
        'system_logo' => secure(''),
        'system_logo_dark' => secure(''),
        'system_favicon_default' => secure('1'),
        'system_favicon' => secure(''),
        'system_ogimage_default' => secure('1'),
        'system_ogimage' => secure(''),
        'play_store_badge_enabled' => secure('0'),
        'play_store_link' => secure(''),
        'appgallery_badge_enabled' => secure('0'),
        'appgallery_store_link' => secure(''),
        'app_store_badge_enabled' => secure('0'),
        'app_store_link' => secure(''),
        'css_customized' => secure('0'),
        'ads_enabled' => secure('0'),
        'wallet_enabled' => secure('0'),
        'packages_enabled' => secure('0'),
        'affiliates_enabled' => secure('0'),
        'points_enabled' => secure('0'),
        'market_enabled' => secure('0'),
        'market_cod_payment_enabled' => secure('0'),
        'market_delivery_days' => secure('30'),
        'funding_enabled' => secure('0'),
        'monetization_enabled' => secure('0'),
        'tips_enabled' => secure('0'),
        'developers_apps_enabled' => secure('0'),
        'developers_share_enabled' => secure('0'),
        'auto_friend' => secure('0'),
        'auto_friend_users' => secure(''),
        'auto_follow' => secure('0'),
        'auto_follow_users' => secure(''),
        'auto_like' => secure('0'),
        'auto_like_pages' => secure(''),
        'auto_join' => secure('0'),
        'auto_join_groups' => secure(''),
        'last_backup_time' => secure(''),
        'cronjob_enabled' => secure('0'),
        'merits_enabled' => secure('0'),
        'merits_peroid_max' => secure('10'),
        'merits_send_peroid_max' => secure('5'),
        'merits_peroid' => secure('1'),
        'merits_peroid_reset' => secure('1'),
        'merits_notifications_recharge' => secure('1'),
        'merits_notifications_reminder' => secure('1'),
        'merits_notifications_recipient' => secure('1'),
        'merits_notifications_sender' => secure('1'),
        'merits_widgets_newsfeed' => secure('1'),
        'merits_widgets_balance' => secure('1'),
        'merits_widgets_winners' => secure('1'),
        'merits_widgets_statistics' => secure('1'),
        'pwa_enabled' => secure('0'),
        'pwa_banner_enabled' => secure('1'),
        'pwa_192_icon' => secure(''),
        'pwa_512_icon' => secure(''),
        'system_api_key' => secure(''),
        'system_api_secret' => secure(''),
        'system_jwt_key' => secure(''),
      ]);
      break;

    case 'api_reset':
      /* generate new api key */
      $api_key = generate_api_key();
      $api_secret = generate_api_secret();
      /* update */
      update_system_options([
        'system_api_key' => secure($api_key),
        'system_api_secret' => secure($api_secret),
      ]);
      break;

    case 'jwt_reset':
      /* generate new jwt key */
      $jwt_key = generate_jwt_key();
      /* update */
      update_system_options([
        'system_jwt_key' => secure($jwt_key),
      ]);
      break;
  }

  // return & exit
  return_json();
} catch (Exception $e) {
  modal("ERROR", __("Error"), $e->getMessage());
}
